﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Validation;

public partial class AdminSystemAvailability : BasePage
{
    private string _currentRegistry = Helpers.GetConfigEntry("Registry");
    private RegistriesCommonManager _commonManager = new RegistriesCommonManager();
    private APPLICATION_STATUS _applicationStatus = new APPLICATION_STATUS();

    public override string TopMenuName()
    {
        return "Administration";
    }
    
    public override string MenuItemName()
    {
        return "System Availability";
    }

    public override string AppObjectCode()
    {
        return "TBI_SYSTEM_AVAILABILITY";
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            LoadControlsFromObject();
        }

        if (RadioButtonListProcessFlag.SelectedValue != "0")
        {
            RequiredFieldValidatorTextBoxWarningMessage.Enabled = true;
        }
        else
        {
            RequiredFieldValidatorTextBoxWarningMessage.Enabled = false;
        }
    }


    #region Object/Form Mapping

    private void LoadControlsFromObject()
    {
        _applicationStatus = _commonManager.GetApplicationStatus(_currentRegistry);
        if (_applicationStatus != null)
        {
            RadioButtonListProcessFlag.SelectedValue = _applicationStatus.PROCESS_FLAG.ToString() ;
            TextBoxWarningMessage.Text = _applicationStatus.MESSAGE;

        }

    }

    private void LoadObjectFromControls()
    {
        _applicationStatus = _commonManager.GetApplicationStatus(_currentRegistry);
        if (_applicationStatus == null)
        {
            _applicationStatus = new APPLICATION_STATUS();
            _applicationStatus.PROCESS_FLAG = 0;
            _applicationStatus.STD_REGISTRY_ID = _commonManager.GetRegistryId(_currentRegistry);
            _applicationStatus.SetAsChangeTrackingRoot();
            _applicationStatus.SetAsInsertOnSubmit();
        }
        else
        {
            _applicationStatus.SetAsChangeTrackingRoot();
            _applicationStatus.SetAsNoChangeOnSubmit();
        }

        if (_applicationStatus.PROCESS_FLAG.ToString() != RadioButtonListProcessFlag.SelectedValue
            || _applicationStatus.MESSAGE != TextBoxWarningMessage.Text)
        {
            if (_applicationStatus.LINQEntityState != EntityState.New)
            {
                _applicationStatus.SetAsUpdateOnSubmit();
            }
            
            _applicationStatus.PROCESS_FLAG = Convert.ToInt32(RadioButtonListProcessFlag.SelectedValue);
            _applicationStatus.MESSAGE = TextBoxWarningMessage.Text;
        }
    }

    #endregion

    #region Postback Events

    protected void ButtonSave_Click(object sender, EventArgs e)
    {
        LoadObjectFromControls();
        int returnStatus = _commonManager.Update(_applicationStatus);
        this.SuppressSaveMessage = false;
        this.IsSaveSuccess = (returnStatus >= 0);
        var master = (RegistryMaster)Master;
        master.SetDirtyFlag(false);

        Session.Remove("SkipWarning");
    }

    protected void ButtonClose_Click(object sender, EventArgs e)
    {
        Response.Redirect("AdminListUsers.aspx");
    }
    #endregion

}
